@extends('layouts.app')

@section('title', 'Edit Thread: ' . $thread->title)

@section('content')
<div class="forum-container">
    <div class="forum-breadcrumbs">
        <a href="{{ route('forum.index') }}">Forums</a>
        <span class="separator">/</span>
        <a href="{{ route('forum.board', $board->slug) }}">{{ $board->name }}</a>
        <span class="separator">/</span>
        <a href="{{ route('forum.thread', [$board->slug, $thread->slug]) }}">{{ \Illuminate\Support\Str::limit($thread->title, 30) }}</a>
        <span class="separator">/</span>
        <span class="current">Edit</span>
    </div>

    <div class="forum-edit-thread">
        <h1>Edit Thread</h1>
        
        <form action="{{ route('forum.update-thread', [$board->slug, $thread->slug]) }}" method="POST">
            @csrf
            @method('PUT')
            
            <div class="form-group">
                <label for="title">Title</label>
                <input type="text" name="title" id="title" class="form-control" value="{{ old('title', $thread->title) }}" required>
                @error('title')
                    <div class="error-message">{{ $message }}</div>
                @enderror
            </div>
            
            <div class="form-group">
                <label for="content">Content</label>
                <x-bbcode-editor 
                    name="content"
                    placeholder="Write your post content here..."
                    :content="old('content', $thread->content)"
                    height="300px"
                />
                @error('content')
                    <div class="error-message">{{ $message }}</div>
                @enderror
            </div>
            
            @if(Auth::user()->can('moderate forums'))
                <div class="moderation-options">
                    <h3>Moderation Options</h3>
                    
                    <div class="form-check">
                        <input type="checkbox" name="is_pinned" id="is_pinned" class="form-check-input" {{ $thread->is_pinned ? 'checked' : '' }}>
                        <label for="is_pinned" class="form-check-label">
                            <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                <path d="M12 2L12 22"></path>
                                <path d="M18 8L12 2 6 8"></path>
                            </svg>
                            Pin Thread
                        </label>
                    </div>
                    
                    <div class="form-check">
                        <input type="checkbox" name="is_locked" id="is_locked" class="form-check-input" {{ $thread->is_locked ? 'checked' : '' }}>
                        <label for="is_locked" class="form-check-label">
                            <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                <rect x="3" y="11" width="18" height="11" rx="2" ry="2"></rect>
                                <path d="M7 11V7a5 5 0 0 1 10 0v4"></path>
                            </svg>
                            Lock Thread
                        </label>
                    </div>
                </div>
            @endif
            
            <div class="form-actions">
                <a href="{{ route('forum.thread', [$board->slug, $thread->slug]) }}" class="btn btn-secondary">Cancel</a>
                <button type="submit" class="btn btn-primary">Save Changes</button>
            </div>
        </form>
    </div>
</div>
@endsection